<?php
namespace App\Http\Controllers\Api;



use App\Http\Controllers\Controller;

use Illuminate\Http\Request;

use App\Models\Category;

use App\Models\Product;

use DB;






class CategoryController extends Controller

{

    /**

     * Display a listing of the resource.

     *

     * @return \Illuminate\Http\Response

     */

    public function index()

    {


// $data = Category::leftJoin('product', 'product.product_category', '=', 'category.cat_id')
//     ->select('category.*', DB::raw("COALESCE(
//         (
//             SELECT SUBSTRING_INDEX(GROUP_CONCAT(sub_product.product_image ORDER BY sub_product.product_id ASC), ',', 1)
//             FROM category AS sub_category
//             LEFT JOIN product AS sub_product ON sub_product.product_category = sub_category.cat_id
//             WHERE sub_category.parent_id = category.cat_id
//         ),
//         SUBSTRING_INDEX(GROUP_CONCAT(product.product_image ORDER BY product.product_id ASC), ',', 1)
//     ) AS product_image"))
//     ->groupBy('category.cat_id')
//     ->where('category.parent_id', '=', 0)
//     ->get();

        $mainCategories = Category::where('parent_id', '=', 0)->get();
        $result = [];
        foreach ($mainCategories as $mainCategory) {
            $subCategories = Category::where('parent_id', '=', $mainCategory->cat_id)->get();
        
            if ($subCategories->isEmpty()) {
                $product = Product::whereRaw("FIND_IN_SET(".$mainCategory->cat_id.", product_category)")->orderBy('product_id', 'ASC')->first();
        
                $image = $product ? $product->product_image : null;
            } else {
                $subProductImages = [];
                foreach ($subCategories as $subCategory) {
                    $subProduct = Product::whereRaw("FIND_IN_SET(".$subCategory->cat_id.", product_category)")->orderBy('product_id', 'ASC')->first();
                    if ($subProduct) {
                        $subProductImages[] = $subProduct->product_image;
                    }
                }
                $image = count($subProductImages) > 0 ? $subProductImages[0] : null;
            }
            $mainCategory->product_image = $image;
            $result[] = $mainCategory;
        }
        return response()->json([
            'code' => 200,
            'success' => True,
            'category' => $result,
        ]);
    }


      public function buildTree(array &$elements, $parentId = 0) {

        $branch = array();

        foreach ($elements as $element) {

            if ($element['parent_id'] == $parentId) {

                $children = $this->buildTree($elements, $element['cat_id']);

                if ($children) {

                    $element['children'] = $children;

                }

                $branch[$element['cat_id']] = $element;

                unset($elements[$element['cat_id']]);

            }

        }

        return $branch;

    }

    





    /**

     * Store a newly created resource in storage.

     *

     * @param  \Illuminate\Http\Request  $request

     * @return \Illuminate\Http\Response

     */

    public function store(Request $request)

    {

        //

    }



    /**

     * Display the specified resource.

     *

     * @param  int  $id

     * @return \Illuminate\Http\Response

     */

    public function show($id)

    {

        //

    }



    /**

     * Update the specified resource in storage.

     *

     * @param  \Illuminate\Http\Request  $request

     * @param  int  $id

     * @return \Illuminate\Http\Response

     */

    public function update(Request $request, $id)

    {

        //

    }



    /**

     * Remove the specified resource from storage.

     *

     * @param  int  $id

     * @return \Illuminate\Http\Response

     */

    public function destroy($id)

    {

        //

    }

}

