<?php
namespace App\Http\Controllers\Api;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\ContactUs;
use Mail;
use App\Models\Inquiry;
use App\Models\QuickInquiry;
use App\Models\ProductInquiry;
use App\Models\Contact;
class ContactUsController extends Controller {
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function contact_list() {
        $data = Contact::all();
        return response()->json([
            'code' => 200,
            'success' => True,
            'contact' => $data,
        ]);
    }
    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function contact_store(Request $request) {
        //$data = (array)$request;
        $data = array(
            "full_name" => $request->full_name,
            "email" => $request->email,
            "phone" => $request->phone,
            "message_text" => $request->message
        );
        Mail::send('contactus.contactmail', $data, function($message) use($data) {
            $message->to('sales@rubberman.co.in')->subject('New Contact Us Form Submission');
            $message->from($data['email']);
        });
        $contact = ContactUs::create([
            'full_name' => ($request->full_name) ? $request->full_name : '',
            'email' => ($request->email) ? $request->email : '',
            'phone' => ($request->phone) ? $request->phone : '',
            'message' => ($request->message) ? $request->message : '',
        ]);
        return response() -> json([
            'success' => true,
            'message' => 'Your form has been submited successfully',
        ]);
    }
    public function inquiry_store(Request $request) { //$data = (array)$request;
        $data = array(
            "full_name" => $request->full_name,
            "product_name" => $request->product_name,
            "email" => $request->email,
            "phone_number" => $request->phone_number,
            "additional_details" => $request->additional_details,
        );
        $email = $data['email'];
        Mail::send('contactus.inquiryMail', $data, function($message) use($data) {
            $message->to('sales@rubberman.co.in')->subject('New Product Inquiry');
            $message->from($data['email'], 'Rubberman');
        });
        $contact = Inquiry::create([
            'full_name' => ($request->full_name) ? $request->full_name : '',
            'product_name' => ($request->product_name) ? $request->product_name : '',
            'email' => ($request->email) ? $request->email : '',
            'phone_number' => ($request->phone_number) ? $request->phone_number : '',
            'additional_details' => ($request->additional_details) ? $request->additional_details : '',
        ]);
        return response() -> json([
            'success' => true,
            'message' => 'Your Quick Inquiry form has been submitted successfully',
        ]);
    }
    public function product_inquiry(Request $request)
    {
        //$data = (array)$request;
        $data = array(
            "full_name" => $request->full_name,
            "product" => $request->product,
            "email" => $request->email,
            "phone_number" => $request->phone_number,
            "message_text" => $request->message_text,
            "subject_line" => $request->subject_line,
        );
        $email = $data['email'];
        Mail::send('contactus.productinquiryMail', $data, function($message) use($email) {
            $message->to('sales@rubberman.co.in')->subject('Quick Product Inquiry | Rubberman');
            $message->from($email, 'Rubberman');
        });
        $contact = ProductInquiry::create([
            'full_name' => ($request->full_name) ? $request->full_name : '',
            // 'subject_line' => ($request->country) ? $request->subject_line : '',
            'email' => ($request->email) ? $request->email : '',
            'phone_number' => ($request->phone_number) ? $request->phone_number : '',
            'message_text' => ($request->message_text) ? $request->message_text : '',
            'product' => ($request->product) ? $request->product : '',
        ]);
        return response() -> json([
            'success' => true,
            'message' => 'Your Inquiry form has been submited successfully',
        ]);
    }
    // quickinquiryMail
    // public function product_inquirey_store(Request $request)
    // {
    //     //$data = (array)$request;
    //     $data = array(
    //         "name" => $request->name,
    //         "industry" => $request->industry,
    //         "application" => $request->application,
    //         "email" => $request->email,
    //         "phone" => $request->phone,
    //         "capacity" => $request->capacity
    //     );
    //     $email = $data['email'];
    //     Mail::send('contactus.productinquiryMail', $data, function($message) use($email) {
    //         $message->to('sales@parthec.com')->to('info@parthec.com')->to('marketing@parthec.com')->subject('Product Detail Inquiry | Parthec');
    //         $message->from($email, 'Parthec');
    //     });
    //     $contact = ProductInquiry::create([
    //         'name' => ($request->name) ? $request->name : '',
    //         'capacity' => ($request->capacity) ? $request->capacity : '',
    //         'email' => ($request->email) ? $request->email : '',
    //         'phone' => ($request->phone) ? $request->phone : '',
    //         'application' => ($request->application) ? $request->application : '',
    //         'industry' => ($request->industry) ? $request->industry : '',
    //     ]);
    //     return response() -> json([
    //         'success' => true,
    //         'message' => 'Your Inquiry form has been submited successfully',
    //     ]);
    // }
    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id) {
        //
    }
    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id) {
        //
    }
    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id) {
        //
    }
}