<?php
namespace App\Http\Controllers;
use Illuminate\Http\Request;
use App\Models\Banner;
use DataTables;
use File;
use Alert;
class BannerController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        $data=Banner::all();
        return view('banner.view',["banner_arr"=>$data]);
    }
    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('banner.add');
    }
    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $request->validate([
            'desktop_image' => 'mimes:jpeg,png,jpg,gif,svg|max:2048',
            'banner_mobile_image' => 'mimes:jpeg,png,jpg,gif,svg|max:2048',
            'banner_name'=> 'required',
        ]);
        $banner = new Banner;
        $banner->banner_name = $request->banner_name;
        $banner->alt_tag = $request->alt_tag;
        $banner->bnr_link = $request->bnr_link;
        $banner->order_by = $request->order_by;

        if($request->hasfile('desktop_image'))
        {
            $file = $request->file('desktop_image');
            $extention = $file->getClientOriginalExtension();
            $randomNumber = random_int(100000, 999999);
            $filename = time().$randomNumber.'.'.$extention;
            $file->move('public/upload/banner', $filename);
            $banner->desktop_image = $filename;
        }
        
        if($request->hasfile('banner_mobile_image'))
        {
            $file = $request->file('banner_mobile_image');
            $extention = $file->getClientOriginalExtension();
            $randomNumber = random_int(10, 99);
            $filename = time().$randomNumber.'.'.$extention;
            $file->move('public/upload/banner', $filename);
            $banner->banner_mobile_image = $filename;
        }
        $banner->save();
    
        Alert::success('Done', 'You\'ve Successfully Add Banner');
        return redirect('/banner/view');
    }
    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }
    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $banner = Banner::find($id);  
        return view('banner.edit',compact('banner'));
    }
    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $request->validate([
            'desktop_image' => 'mimes:jpeg,png,jpg,gif,svg|max:2048',
         'banner_mobile_image' => 'mimes:jpeg,png,jpg,gif,svg|max:2048',
            'banner_name'=> 'required',
        ]);
        $banner = Banner::where('banner_id', $request->id)->first();
        $banner->banner_name = $request->banner_name;
        $banner->bnr_link = $request->bnr_link;
        $banner->order_by = $request->order_by;
        $banner->alt_tag = $request->alt_tag;
           
        if($request->hasfile('desktop_image'))
        {
            $destination = 'public/upload/banner'.$banner->desktop_image;
            if(File::exists($destination))
            {
                File::delete($destination);
            }
            $file = $request->file('desktop_image');
            $extention = $file->getClientOriginalExtension();
            $randomNumber = random_int(100000, 999999);
            $filename = time().$randomNumber.'.'.$extention;
            $file->move('public/upload/banner', $filename);
            $banner->desktop_image = $filename;
         }
if($request->hasfile('banner_mobile_image'))
        {
            $destination = 'public/upload/banner'.$banner->banner_mobile_image;
            if(File::exists($destination))
            {
                File::delete($destination);
            }
            $file = $request->file('banner_mobile_image');
            $extention = $file->getClientOriginalExtension();
            $randomNumber = random_int(10, 99);
            $filename = time().$randomNumber.'.'.$extention;
            $file->move('public/upload/banner', $filename);
            $banner->banner_mobile_image = $filename;
         }
         $banner->update();    
         Alert::success('Done', 'You\'ve Successfully Update Banner');
         return redirect('/banner/edit/'.$id);
    }
    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $banner = Banner::where('banner_id','=',$id)->delete();
        Alert::success('Done', 'You\'ve Successfully Delete Banner');
        return back();
    }
}
