<?php
namespace App\Http\Controllers;
use Illuminate\Http\Request;
use App\Models\Category;
use App\Models\Product;
use DB;
use DataTables;
use File;
use Alert;
use Illuminate\Support\Str;
use App\Models\CategoryProduct;
class CategoryController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    { 
    
        $data=Category::all();
        return view('category.view',["category_arr"=>$data]);
 
    }
    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
       $result = Category::all()->toArray();
       $my_category_tree = $this->buildTree($result,0);
        return view('category.add',compact('my_category_tree'));
    }
    public function buildTree(array &$elements, $parentId = 0) {
        $branch = array();
    
        foreach ($elements as $element) {
            if ($element['parent_id'] == $parentId) {
                $children = $this->buildTree($elements, $element['cat_id']);
                if ($children) {
                    $element['children'] = $children;
                }
                $branch[$element['cat_id']] = $element;
                unset($elements[$element['cat_id']]);
            }
        }
        return $branch;
    }
    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        // $request->validate([
        //     'category_image' => 'mimes:jpeg,png,jpg,gif,svg|max:2048',
        //     'main_image' => 'mimes:jpeg,png,jpg,gif,svg|max:2048',
        //     'category_name'=> 'required',
          
        // ]);
        $request->validate([
            'category_image' => 'mimes:jpeg,png,jpg,gif,svg',
            'main_image' => 'mimes:mp4,mov,avi,wmv,flv,webm',
            'category_name'=> 'required',
        ]);
        $category = new Category;
        $category->cat_name = $request->category_name;
        $category->parent_id = $request->parent_id ?: '0';
        $category->slug= Str::slug($request->category_name);
        $category->full_desc = $request->full_desc;
   $category->alt_tag = $request->alt_tag;
        $category->meta_title = $request->meta_title;
        $category->meta_keyword = $request->meta_keyword;
        $category->meta_desc = $request->meta_desc;
        $category->order_by = $request->order_by;
        $category->faqs = $request->faqs;
        if($request->hasfile('category_image'))
        {
            $file = $request->file('category_image');
            $extention = $file->getClientOriginalExtension();
            $randomNumber = random_int(100000, 999999);
            $filename = time().$randomNumber.'.'.$extention;
            $file->move('public/upload/category', $filename);
            $category->cat_img = $filename;
        }
        if($request->hasfile('main_image'))
        {
            $file = $request->file('main_image');
            $extention = $file->getClientOriginalExtension();
            $randomNumber = random_int(100000, 999999);
            $filename = time().$randomNumber.'.'.$extention;
            $file->move('public/upload/category', $filename);
            $category->main_image = $filename;
        }
        $category->save();
 
        Alert::success('Done', 'You\'ve Successfully Add Category');
        return redirect('/category/view');
    }
    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }
    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $category = Category::find($id);  
        $cate = Category::where('parent_id','=', 0)->get();
        return view('category.edit',compact('category','cate'));
    }
    
    // public function show_product($id)
    // {
    // $category_product = CategoryProduct::where('category_id','=', $id)
    // ->leftJoin('product', 'product.product_id', '=', 'category_product.product_id')
    // ->leftJoin('category', 'category.cat_id', '=', 'category_product.category_id')
    // ->select('product.product_name','product.product_image','category.cat_name','category_product.order_by',
    // 'category_product.product_id','category_product.category_id','product.product_slug')
    // ->orderBy('order_by','ASC')
    // ->get();
    // return view('category.show_product',compact('category_product'));
    // }
    public function show_product($id)
    {
        $category_product = Product::where('product_category', $id)->get();
        return view('category.show_product', compact('category_product'));
    }
    
    public function updateOrder(Request $request)
{
    $category_id = $request->input('category_id');
    $product_id = $request->input('product_id');
    $order_by = $request->input('order_by');
    // Update the order_by value using Eloquent
    CategoryProduct::where('category_id', $category_id)
                   ->where('product_id', $product_id)
                   ->update(['order_by' => $order_by]);
    return response()->json(['message' => 'Order updated successfully']);
}
    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        // $request->validate([
        //     'category_image' => 'mimes:jpeg,png,jpg,gif,svg|max:2048',
        //     'main_image' => 'mimes:jpeg,png,jpg,gif,svg|max:2048',
        //     'category_name'=> 'required',
        // ]);
        $request->validate([
            'category_image' => 'mimes:jpeg,png,jpg,gif,svg',
            'main_image' => 'mimes:mp4,mov,avi,wmv,flv,webm',
            'category_name'=> 'required',
        ]);
        $category = Category::where('cat_id', $request->id)->first();
        $category->cat_name = $request->category_name;
        $category->parent_id = $request->parent_id ?: '0';
        $category->slug= $request->slug;
        $category->full_desc = $request->full_desc;
           $category->alt_tag = $request->alt_tag;
        $category->meta_title = $request->meta_title;
        $category->meta_keyword = $request->meta_keyword;
        $category->meta_desc = $request->meta_desc;
    $category->order_by = $request->order_by;
    $category->faqs = $request->faqs;
           
        if($request->hasfile('category_image'))
        {
            $destination = 'public/upload/category'.$category->cat_img;
            if(File::exists($destination))
            {
                File::delete($destination);
            }
            $file = $request->file('category_image');
            $extention = $file->getClientOriginalExtension();
            $randomNumber = random_int(100000, 999999);
            $filename = time().$randomNumber.'.'.$extention;
            $file->move('public/upload/category', $filename);
            $category->cat_img = $filename;
         }
         if($request->hasfile('main_image'))
         {
             $destination = 'public/upload/category'.$category->main_image;
             if(File::exists($destination))
             {
                 File::delete($destination);
             }
             $file = $request->file('main_image');
             $extention = $file->getClientOriginalExtension();
             $randomNumber = random_int(100000, 999999);
             $filename = time().$randomNumber.'.'.$extention;
             $file->move('public/upload/category', $filename);
             $category->main_image = $filename;
          }
         $category->update();    
         Alert::success('Done', 'You\'ve Successfully Update Category');
         return redirect('/category/edit/'.$id);
    }
    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $category = Category::where('cat_id','=',$id)->delete();
        Alert::success('Done', 'You\'ve Successfully Delete Category');
        return back();
    }
}
