<?php



namespace App\Http\Controllers;



use Illuminate\Http\Request;

use App\Models\Certificate;

use DataTables;

use File;

use Alert;



class CertificateController extends Controller

{

    /**

     * Display a listing of the resource.

     *

     * @return \Illuminate\Http\Response

     */

    public function index(Request $request)

    {

        $data=Certificate::all();

        return view('certificate.view',["certificate_arr"=>$data]);

    }



    /**

     * Show the form for creating a new resource.

     *

     * @return \Illuminate\Http\Response

     */

    public function create()

    {

        return view('certificate.add');

    }



    /**

     * Store a newly created resource in storage.

     *

     * @param  \Illuminate\Http\Request  $request

     * @return \Illuminate\Http\Response

     */

    public function store(Request $request)

    {

        $request->validate([

            'certi_image' => 'mimes:jpeg,png,jpg,gif,svg|max:2048',
            'certi_pdf' => 'mimes:pdf,xlx,csv|max:2048',


        ]);





        $certificate = new Certificate;

        $certificate->certi_title = $request->certi_title;



        if($request->hasfile('certi_image'))

        {

            $file = $request->file('certi_image');

            $extention = $file->getClientOriginalExtension();

            $randomNumber = random_int(10, 99);

            $filename = time().$randomNumber.'.'.$extention;

            $file->move('public/upload/certificate', $filename);

            $certificate->certi_image = $filename;

        }
        
          if($request->hasfile('certi_pdf'))

        {

            $file = $request->file('certi_pdf');

            $extention = $file->getClientOriginalExtension();

            $randomNumber = random_int(10, 99);

            $filename = time().$randomNumber.'.'.$extention;

            $file->move('public/upload/certificate', $filename);

            $certificate->certi_pdf = $filename;

        }

       
            

       

        $certificate->save();

    

        Alert::success('Done', 'You\'ve Successfully Add Banner');

        return redirect('/certificate/view');

    }

    /**

     * Display the specified resource.

     *

     * @param  int  $id

     * @return \Illuminate\Http\Response

     */

    public function show($id)

    {

        //

    }



    /**

     * Show the form for editing the specified resource.

     *

     * @param  int  $id

     * @return \Illuminate\Http\Response

     */

    public function edit($id)

    {

        $certificate = Certificate::find($id);  

        return view('certificate.edit',compact('certificate'));

    }



    /**

     * Update the specified resource in storage.

     *

     * @param  \Illuminate\Http\Request  $request

     * @param  int  $id

     * @return \Illuminate\Http\Response

     */

    public function update(Request $request, $id)

    {

        
        $request->validate([

            'certi_image' => 'mimes:jpeg,png,jpg,gif,svg|max:2048',

     'certi_pdf' => 'mimes:pdf,xlx,csv|max:2048',



        ]);




        $certificate = Certificate::where('certi_id', $request->id)->first();

       $certificate->certi_title = $request->certi_title;

   
       


         if($request->hasfile('certi_image'))

         {

             $destination = 'public/upload/certificate'.$certificate->certi_image;

             if(File::exists($destination))

             {

                 File::delete($destination);

             }

             $file = $request->file('certi_image');

             $extention = $file->getClientOriginalExtension();

             $randomNumber = random_int(10, 99);

             $filename = time().$randomNumber.'.'.$extention;

             $file->move('public/upload/certificate', $filename);

             $certificate->certi_image = $filename;

          }
          
           if($request->hasfile('certi_pdf'))

         {

             $destination = 'public/upload/certificate'.$certificate->certi_pdf;

             if(File::exists($destination))

             {

                 File::delete($destination);

             }

             $file = $request->file('certi_pdf');

             $extention = $file->getClientOriginalExtension();

             $randomNumber = random_int(10, 99);

             $filename = time().$randomNumber.'.'.$extention;

             $file->move('public/upload/certificate', $filename);

             $certificate->certi_pdf = $filename;

          }

          
              
         $certificate->update();    

         Alert::success('Done', 'You\'ve Successfully Update Certificate');

         return redirect('/certificate/edit/'.$id);

    }



    /**

     * Remove the specified resource from storage.

     *

     * @param  int  $id

     * @return \Illuminate\Http\Response

     */

    public function destroy($id)

    {

        $certificate = Certificate::where('certi_id','=',$id)->delete();

        Alert::success('Done', 'You\'ve Successfully Delete Certificate');

        return back();

    }

}

