<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Cms;
use Alert;
use Session;
use File;
use Illuminate\Support\Str;

class Cmscontroller extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $data=Cms::all();
        return view('cms.view',["cms_arr"=>$data]);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('cms.add');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $data=$request->validate([
            'page_title' => 'required',
            'banner_img' => 'mimes:jpeg,png,jpg,gif,svg|max:2048'
            
        
        ]);
        $data=new Cms;
        $data->page_title=$request->page_title;
        $data->description=$request->description;
        $data->meta_title=$request->meta_title;
        $data->meta_description=$request->meta_description;
        $data->meta_keywords=$request->meta_keywords;
        $data->slug= Str::slug($request->page_title);
        $data->alt_tag=$request->alt_tag;
        $data->page_display=$request->page_display;
        if($request->hasfile('banner_img'))
        {
            $file = $request->file('banner_img');
            $extention = $file->getClientOriginalExtension();
            $filename = time().'.'.$extention;
            $file->move('public/upload/cms', $filename);
            $data->banner_img = $filename;
        }

        $data->save();
        Alert::success('Done', 'You\'ve Successfully Add CMS');
           return redirect('/cms/view');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $cms=cms::find($id);
        return view('cms.edit',compact('cms'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $data=$request->validate([
            'page_title' => 'required',
            'banner_img' => 'mimes:jpeg,png,jpg,gif,svg|max:2048'
        ]);

        $data = Cms::where('id', $id)->first();
        $data->page_title=$request->page_title;
        $data->description=$request->description;
        $data->meta_title=$request->meta_title;
        $data->meta_description=$request->meta_description;
        $data->meta_keywords=$request->meta_keywords;
        $data->slug= Str::slug($request->page_title);
        $data->alt_tag=$request->alt_tag;
   $data->page_display=$request->page_display;
        if($request->hasfile('banner_img'))
        {
            $destination = 'public/upload/cms'.$data->banner_img;
            if(File::exists($destination))
            {
                File::delete($destination);
            }
            $file = $request->file('banner_img');
            $extention = $file->getClientOriginalExtension();
            $filename = time().'.'.$extention;
            $file->move('public/upload/cms', $filename);
            $data->banner_img = $filename;
        }
        $data->save();
        Alert::success('Done', 'You\'ve Successfully Update CMS');
		  return redirect('/cms/edit/'.$id);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $data=Cms::find($id);
		
        $data->delete();
		Alert::success('Done', 'You\'ve Successfully Delete CMS');
        return back();
		
    }
}
