<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Contact;
use DB;
use DataTables;
use File;
use Alert;
use Illuminate\Support\Str;

class ContactController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    { 
    
        $data=Contact::all();
        return view('contact.view',["contact_arr"=>$data]);

 
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('contact.add');
    }


    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $request->validate([
            'title'=> 'required',
          
        ]);


        $contact = new Contact;

        $contact->title = $request->title;
        $contact->desc = $request->desc;
        $contact->sub_title = $request->sub_title;
        $contact->save();
 
        Alert::success('Done', 'You\'ve Successfully Add Contact');
        return redirect('/contact/view');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $contact = Contact::find($id);  
        return view('contact.edit',compact('contact'));
    }
    



    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $request->validate([
            'title'=> 'required',
          
        ]);

        $contact = Contact::where('id', $request->id)->first();
        $contact->title = $request->title;
        $contact->desc = $request->desc;
        $contact->sub_title = $request->sub_title;
 
         $contact->update();    

         Alert::success('Done', 'You\'ve Successfully Update Contact');
         return redirect('/contact/edit/'.$id);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $contact = Contact::where('id','=',$id)->delete();

        Alert::success('Done', 'You\'ve Successfully Delete Contact');
        return back();
    }
}
