<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\ContactUs; 
use DataTables;
use Alert;
use App\Models\ProductInquiry;
use DB;
use App\Models\Inquiry;
use App\Models\QuickInquiry;
use Illuminate\Support\Facades\Response;
class ContactUsController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
  
        $data=ContactUs::all();
        return view('contactus.view',["cont_arr"=>$data]);
    }
    
        public function product_inquiry(Request $request)
    {
  
        $data=ProductInquiry::all();
        return view('contactus.view_product_inquiry',["cont_arr"=>$data]);
    }
    
public function quick_inquiry(Request $request)
{
    $startDate = $request->input('start_date');
    $endDate = $request->input('end_date');

    if (empty($startDate) && empty($endDate)) {
        // Case 1: No start date and no end date provided
        $data = Inquiry::all();
    } elseif (!empty($startDate) && empty($endDate)) {
        // Case 2: Only start date provided
        $startDate = date('Y-m-d', strtotime($startDate));
        $data = Inquiry::whereDate('created_at', '=', $startDate)->get();
    } elseif (empty($startDate) && !empty($endDate)) {
        // Case 3: Only end date provided
        $endDate = date('Y-m-d', strtotime($endDate));
        $data = Inquiry::whereDate('created_at', '=', $endDate)->get();
    } else {
        // Case 4: Both start date and end date provided
        $startDate = date('Y-m-d', strtotime($startDate));
        $endDate = date('Y-m-d', strtotime($endDate));
        $data = Inquiry::whereBetween('created_at', [$startDate, $endDate])->get();
    }

    if ($request->has('export')) {
        $csvFileName = 'quick_inquiry.csv';

        $headers = array(
            "Content-type" => "text/csv",
            "Content-Disposition" => "attachment; filename=$csvFileName",
            "Pragma" => "no-cache",
            "Cache-Control" => "must-revalidate, post-check=0, pre-check=0",
            "Expires" => "0"
        );

        $columns = array('Product Name', 'Name', 'Email', 'Phone', 'Message', 'Date');

        $callback = function () use ($data, $columns) {
            $file = fopen('php://output', 'w');
            fputcsv($file, $columns);

            foreach ($data as $row) {
                $rowData = [
                    $row->product_name,
                    $row->full_name,
                    $row->email,
                    $row->phone_number,
                    $row->additional_details,
                    date('Y-m-d', strtotime($row->created_at))
                ];
                fputcsv($file, $rowData);
            }

            fclose($file);
        };

        return response()->stream($callback, 200, $headers);
    }

    return view('contactus.view_quick_inquiry', ["cont_arr" => $data]);
}

public function inquiry(Request $request)
{
    $startDate = $request->input('start_date');
    $endDate = $request->input('end_date');

    if (empty($startDate) && empty($endDate)) {
        // Case 1: No start date and no end date provided
        $data = Inquiry::all();
    } elseif (!empty($startDate) && empty($endDate)) {
        // Case 2: Only start date provided
        $startDate = date('Y-m-d', strtotime($startDate));
        $data = Inquiry::whereDate('created_at', '=', $startDate)->get();
    } elseif (empty($startDate) && !empty($endDate)) {
        // Case 3: Only end date provided
        $endDate = date('Y-m-d', strtotime($endDate));
        $data = Inquiry::whereDate('created_at', '=', $endDate)->get();
    } else {
        // Case 4: Both start date and end date provided
        $startDate = date('Y-m-d', strtotime($startDate));
        $endDate = date('Y-m-d', strtotime($endDate));
        $data = Inquiry::whereBetween('created_at', [$startDate, $endDate])->get();
    }

    if ($request->has('export')) {
        $csvFileName = 'inquiry.csv';

        $headers = array(
            "Content-type" => "text/csv",
            "Content-Disposition" => "attachment; filename=$csvFileName",
            "Pragma" => "no-cache",
            "Cache-Control" => "must-revalidate, post-check=0, pre-check=0",
            "Expires" => "0"
        );

        $columns = array('Name', 'Email', 'Phone','Message', 'Date');

        $callback = function () use ($data, $columns) {
            $file = fopen('php://output', 'w');
            fputcsv($file, $columns);

            foreach ($data as $row) {
                $rowData = [
                    // $row->product,
                    $row->full_name,
                    $row->email,
                    $row->phone_number,
                    //   $row->country,
                    $row->additional_details,
                    date('Y-m-d', strtotime($row->created_at))
                ];
                fputcsv($file, $rowData);
            }

            fclose($file);
        };

        return response()->stream($callback, 200, $headers);
    }

    return view('contactus.view_inquiry', ["cont_arr" => $data]);
}
    
public function exportCsv(Request $request)
{
    $startDate = $request->input('start_date');
    $endDate = $request->input('end_date');

    if (empty($startDate) && empty($endDate)) {
        // Case 1: No start date and no end date provided
        $data = ProductInquiry::all();
    } elseif (!empty($startDate) && empty($endDate)) {
        // Case 2: Only start date provided
        $startDate = date('Y-m-d', strtotime($startDate));
        $data = ProductInquiry::whereDate('created_at', '=', $startDate)->get();
    } elseif (empty($startDate) && !empty($endDate)) {
        // Case 3: Only end date provided
        $endDate = date('Y-m-d', strtotime($endDate));
        $data = ProductInquiry::whereDate('created_at', '=', $endDate)->get();
    } else {
        // Case 4: Both start date and end date provided
        $startDate = date('Y-m-d', strtotime($startDate));
        $endDate = date('Y-m-d', strtotime($endDate));
        $data = ProductInquiry::whereBetween('created_at', [$startDate, $endDate])->get();
    }

    if ($request->has('export')) {
        $csvFileName = 'product_inquiry.csv';

        $headers = array(
            "Content-type" => "text/csv",
            "Content-Disposition" => "attachment; filename=$csvFileName",
            "Pragma" => "no-cache",
            "Cache-Control" => "must-revalidate, post-check=0, pre-check=0",
            "Expires" => "0"
        );

        $columns = array('Industry', 'Application', 'Capacity', 'Name', 'Email', 'Phone', 'Date');

        $callback = function () use ($data, $columns) {
            $file = fopen('php://output', 'w');
            fputcsv($file, $columns);

            foreach ($data as $row) {
                $rowData = [
                    $row->industry,
                    $row->application,
                    $row->capacity,
                    $row->name,
                    $row->email,
                    $row->phone,
                    date('Y-m-d', strtotime($row->created_at))
                ];
                fputcsv($file, $rowData);
            }

            fclose($file);
        };

        return response()->stream($callback, 200, $headers);
    }

    return view('contactus.view_product_inquiry', ["cont_arr" => $data]);
}

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
