<?php
namespace App\Http\Controllers;
use Illuminate\Http\Request;
use App\Models\Industry; 
use DataTables;
use File;
use Alert;
use Illuminate\Support\Str;
use App\Models\Application;
class IndustryController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $industry = Industry::all();
        return view('industry.view',compact('industry'));
    }
    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
           $application = Application::all();
        return view('industry.add',compact('application'));
    }
    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $request->validate([
            'name'=> 'required',
        ]);
        $industry = new Industry;
        $industry->name = $request->name;
        $industry->ind_ico = $request->ind_ico;
        $industry->slug= Str::slug($request->name);
        //  if($request->application_id){
        //     $industry->application_id = implode(',',$request->application_id);
        // }else{
        //     $industry->application_id = '';
        // }
        if($request->hasfile('ind_ico'))
        {
            $file = $request->file('ind_ico');
            $extention = $file->getClientOriginalExtension();
            $randomNumber = random_int(100000, 999999);
            $filename = time().$randomNumber.'.'.$extention;
            $file->move('public/upload/industry', $filename);
            $industry->ind_ico = $filename;
        }

        $industry->save();
        Alert::success('Done', 'You\'ve Successfully Add Industry');
         return redirect('/industry/view');
    }
    
    
    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }
    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $industry = Industry::find($id);  
               $application = Application::all();
        return view('industry.edit',compact('industry','application'));
    }
    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $request->validate([
           'name'=> 'required',
        ]);
        $industry = Industry::where('id', $request->id)->first();
        $industry->name = $request->name;
        $industry->ind_ico = $request->ind_ico;
        $industry->slug= $request->slug;
  
            // if($request->application_id){
            //     $industry->application_id = implode(',',$request->application_id);
            // }else{
            //     $industry->application_id = '';
            // }
        if($request->hasfile('ind_ico'))
        {
            $file = $request->file('ind_ico');
            $extention = $file->getClientOriginalExtension();
            $randomNumber = random_int(100000, 999999);
            $filename = time().$randomNumber.'.'.$extention;
            $file->move('public/upload/industry', $filename);
            $industry->ind_ico = $filename;
        }
        $industry->update();    
         
        Alert::success('Done', 'You\'ve Successfully Update Industry');
        return redirect('/industry/edit/'.$id);
    }
    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $industry=Industry::find($id);
        $industry->delete();
        Alert::success('Done', 'You\'ve Successfully Delete Industry');
        return back();
    }
}
