<?php



namespace App\Http\Controllers;



use Illuminate\Http\Request;

use App\Models\Testimonials;

use DataTables;

use Alert;

use File;


class TestimonialsController extends Controller

{

    /**

     * Display a listing of the resource.

     *

     * @return \Illuminate\Http\Response

     */

    public function index(Request $request)

    {

        $data=Testimonials::all();
        return view('testimonials.view',["testi_arr"=>$data]);

    }



    /**

     * Show the form for creating a new resource.

     *

     * @return \Illuminate\Http\Response

     */

    public function create()

    {

        return view('testimonials.add');

    }


    /**

     * Store a newly created resource in storage.

     *

     * @param  \Illuminate\Http\Request  $request

     * @return \Illuminate\Http\Response

     */

    public function store(Request $request)

    {

        $request->validate([

            'testi_title'=> 'required',
            'testi_image' => 'mimes:jpeg,png,jpg,gif,svg|max:2048',

        ]);

        $testimonails = new Testimonials;
        $testimonails->testi_title = $request->testi_title;
        $testimonails->testi_company_name = $request->testi_company_name;
        $testimonails->testi_position = $request->testi_position;
        $testimonails->testi_desc = $request->testi_desc;
        if($request->hasfile('testi_image'))
        {
            $file = $request->file('testi_image');
            $extention = $file->getClientOriginalExtension();
            $filename = time().'.'.$extention;
            $file->move('public/upload/testimonials', $filename);
            $testimonails->testi_image = $filename;
        }
      
        $testimonails->save();

        Alert::success('Done', 'You\'ve Successfully Add Testimonials');
        return redirect('/testimonials/view');

    }

    /**

     * Display the specified resource.

     *

     * @param  int  $id

     * @return \Illuminate\Http\Response

     */

    public function show($id)

    {

        //

    }



    /**

     * Show the form for editing the specified resource.

     *

     * @param  int  $id

     * @return \Illuminate\Http\Response

     */

    public function edit($id)

    {

        $testimonails = Testimonials::find($id);  

        return view('testimonials.edit',compact('testimonails'));

    }



    /**

     * Update the specified resource in storage.

     *

     * @param  \Illuminate\Http\Request  $request

     * @param  int  $id

     * @return \Illuminate\Http\Response

     */

    public function update(Request $request, $id)

    {

        $request->validate([

            'testi_title'=> 'required',
            'testi_image' => 'mimes:jpeg,png,jpg,gif,svg|max:2048',
        ]);




        $testimonails = Testimonials::where('testi_id', $request->id)->first();
        $testimonails->testi_title = $request->testi_title;
        $testimonails->testi_company_name = $request->testi_company_name;
        $testimonails->testi_position = $request->testi_position;
        $testimonails->testi_desc = $request->testi_desc;
        if($request->hasfile('testi_image'))
        {
            $destination = 'public/upload/testimonials'.$testimonails->testi_image;
            if(File::exists($destination))
            {
                File::delete($destination);
            }
            $file = $request->file('testi_image');
            $extention = $file->getClientOriginalExtension();
            $filename = time().'.'.$extention;
            $file->move('public/upload/testimonials', $filename);
            $testimonails->testi_image = $filename;
        }
      
         $testimonails->update();    

         Alert::success('Done', 'You\'ve Successfully Update Testimonials');
         return redirect('/testimonials/edit/' .$id);

    }



    /**

     * Remove the specified resource from storage.

     *

     * @param  int  $id

     * @return \Illuminate\Http\Response

     */

    public function destroy($id)

    {

        $testimonails = Testimonials::where('testi_id','=',$id)->delete();

		Alert::success('Done', 'You\'ve Successfully Delete Testimonials');
        return back();
		

    }



}

