<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Video;
use DataTables;
use File;
use Alert;

class VideoController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $video=Video::all();
        return view('video.view',compact('video'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('video.add');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $request->validate([
            'video_link'=> 'required',
            'video_image' => 'mimes:jpeg,png,jpg,gif,svg,webp|max:2048',
        ]);

        $video = new Video;
        $video->video_title = $request->video_title;
        $video->video_link = $request->video_link;
        
        if($request->hasfile('video_image'))
        {
            $file = $request->file('video_image');
            $extention = $file->getClientOriginalExtension();
            $randomNumber = random_int(10, 99);
            $filename = time().$randomNumber.'.'.$extention;
            $file->move('public/upload/video', $filename);
            $video->video_image = $filename;
        }
        
        $video->save();


        Alert::success('Done', 'You\'ve Successfully Add Video');
         return redirect('/video/view');
    }
    
    

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $video = Video::find($id);  
        return view('video.edit',compact('video'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
          $request->validate([
            'video_link'=> 'required',
            'video_image' => 'mimes:jpeg,png,jpg,gif,svg,webp|max:2048',
        ]);


        $video = Video::where('video_id', $request->id)->first();
        $video->video_title = $request->video_title;
        $video->video_link = $request->video_link;
       
       
        if($request->hasfile('video_image'))
        {
            $destination = 'public/upload/video'.$video->video_image;
            if(File::exists($destination))
            {
                File::delete($destination);
            }
            $file = $request->file('video_image');
            $extention = $file->getClientOriginalExtension();
            $randomNumber = random_int(10, 99);
            $filename = time().$randomNumber.'.'.$extention;
            $file->move('public/upload/video', $filename);
            $video->video_image = $filename;
         }
         
         $video->update();     
         Alert::success('Done', 'You\'ve Successfully Update Video');
        return redirect('/video/edit/'.$id);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {

        $video=Video::find($id);
        $video->delete();
        Alert::success('Done', 'You\'ve Successfully Delete Video');
        return back();

    }
}
