<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('cms', function (Blueprint $table) {
            $table->unsignedBigInteger('admin_id');
			$table->foreign('admin_id')->references('id')->on('admins')->after('id');
            $table->string('page_title')->after('id');
            $table->string('page_title_fr')->after('page_title');
            $table->string('description')->after('page_title_fr');
            $table->string('description_fr')->after('description');
            $table->string('url')->after('description_fr');
            $table->string('banner_img')->after('url');
            $table->string('meta_title')->after('banner_img');
            $table->string('meta_title_fr')->after('meta_title');
            $table->string('meta_description')->after('meta_title_fr');
            $table->string('meta_description_fr')->after('meta_description');
            $table->string('meta_keywords')->after('meta_description_fr');
            $table->string('meta_keywords_fr')->after('meta_keywords');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('cms', function (Blueprint $table) {
            //
        });
    }
};
