@extends('Admin.Layout.main_layout') 	
@section('title','Home Setting')
@section('main_container')
                <!-- begin app-main -->
                <div class="app-main" id="main">
                    <!-- begin container-fluid -->
                    <div class="container-fluid">
                        <!-- begin row -->
                        <div class="row">
                            <div class="col-md-12 m-b-30">
                                <!-- begin page title -->
                                <div class="d-block d-sm-flex flex-nowrap align-items-center">
                                    <div class="page-title mb-2 mb-sm-0">
                                        <h1>Home</h1>
                                    </div>
                                    <div class="ml-auto d-flex align-items-center">
                                        <nav>
                                            <ol class="breadcrumb p-0 m-b-0">
                                                <li class="breadcrumb-item">
                                                    <a href="index.html"><i class="ti ti-home"></i></a>
                                                </li>
                                                <li class="breadcrumb-item">
                                                Home
                                                </li>
                                                <li class="breadcrumb-item active text-primary" aria-current="page">Home Setting
                                        </nav>
                                    </div>
                                </div>
                                <!-- end page title -->
                            </div>
                        </div>
                        <!-- end row -->

                        <!--mail-Compose-contant-start-->
                        <div class="row account-contant">
                            <div class="col-12">
                                <div class="card card-statistics">
                                    <div class="card-body p-0">
                                        <div class="row no-gutters">
                                            
                                            
                                                <div class="page-account-form">
                                                    <div class="form-titel border-bottom p-3">
                                                        <h5 class="mb-0 py-2">Add Sub Img of Home</h5>
                                                    </div>
                                                    <div class="p-4">
                                                        
                                                            <div class="card-body row">
                                                            
                                                                <div class="col-12 col-md-5 col-lg-5">
                                                                    <form action="{{ route('Home_img.store') }}" method="post" enctype="multipart/form-data">
                                                                    @csrf
                                                                        <div class="form-group">
                                                                            <label>Sub Title</label>
                                                                            <input type="text" class="form-control" name="sub_title">
                                                                            @if ($errors->has('sub_title'))
                                                                                <span class="text-danger">{{ $errors->first('sub_title') }}</span>
                                                                            @endif
                                                                        </div>
                                                                        
                                                                        <div class="form-group">
                                                                            <label>Sub Img</label>
                                                                            <div class="input-group">
                                                                            <input type="file" class="form-control" name="sub_img"  ><br>
                                                                            </div>
                                                                            @if($errors->has('sub_img'))	
                                                                                <span class="text-danger" >{{($errors->first('sub_img'))}}</span>
                                                                            @endif
                                                                        </div>
                                                                </div>
                                                                    <div class="col-12 col-md-5 col-lg-5">
                                                                    <div class="form-group">
                                                                            <label>Sub Title (French)</label>
                                                                            <input type="text" class="form-control" name="sub_title_fr">
                                                                            @if ($errors->has('sub_title_fr'))
                                                                                <span class="text-danger">{{ $errors->first('sub_title_fr') }}</span>
                                                                            @endif
                                                                        </div>
                                                                       
                                                                    </div>
                                                                    <div class="col-6 col-md-3 col-lg-3 form-group" >
                                                                        <button type="submit" class="btn btn-primary btn-lg btn-block" name="submit" value="Send">Add Sub Img</button>
                                                                    </div> 
                                                                    </form>
                                                                
                                                                <div class="col-12 col-md-12 col-lg-12">
                                                                    <div class="card-header">
                                                                        <h4>View Sub Img</h4>
                                                                    </div><br>
                                                                    <div class="table-responsive">
                                                                        <table id="table" class="table table-bordered">
                                                                            <thead>
                                                                                <tr>
                                                                                    <th scope="col">id</th>
                                                                                    <th scope="col">Sub Title</th>
                                                                                    <th scope="col">Sub Title (French)</th>
                                                                                    <th class="text-center">Actions</th>
                                                                                </tr>
                                                                            </thead>
                                                                            <tbody>
                                                                            @if(!$home_setting_arr->isEmpty())
                                                                            @foreach($home_setting_arr as $data)
                                                                                <tr>
                                                                                <th scope="row"><?php echo $data->id ?></th>
                                                                                <td><?php echo $data->sub_title?></td>
                                                                                <td><?php echo $data->sub_title_fr?></td>
                                                                                <td class="text-left">
                                                                                    <div class="actions">
                                                                                        <a class="btn btn-sm bg-success-light"  href="{{url('home/edit_sub_img/'.$data->id)}}">
                                                                                            <i class="fe fe-edit" style="font-size: 2em;"></i> 
                                                                                        </a>
                                                                                        <a  href="{{url('home/destroy_sub_img/'. $data->id)}}" class="btn btn-sm bg-danger-light">
                                                                                            <i class="fe fe-trash" style="font-size: 2em;"></i>
                                                                                        </a>
                                                                                    </div>
                                                                                </td>
                                                                                </tr>
                                                                            @endforeach  
                                                                            @else
                                                                                <p class="text-danger mt-2" style="padding-left:375px">No Sub Images Available</p>
                                                                            @endif
                                                                            </tbody>
                                                                        </table>
                                                                    </div>
                                                                </div>
                                                               
                                                                    
                                                                
                                                            </div>
                                                        
                                                            
                                                            
                                                        </div>   
                                                    
                                                    </div>
                                                </div>
                                           
                                           
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <!--mail-Compose-contant-end-->
                    </div>
                    <!-- end container-fluid -->
                </div>
                <!-- end app-main -->
            </div>
            <!-- end app-container -->
           @endsection