@extends('Admin.Layout.main_layout') 	
@section('main_container')
<!-- begin app-main -->
<div class="app-main" id="main">
   <!-- begin container-fluid -->
   <div class="container-fluid">
      <!-- begin row -->
      <div class="row">
         <div class="col-md-12 m-b-30">
            <!-- begin page title -->
            <div class="d-block d-sm-flex flex-nowrap align-items-center">
               <div class="page-title mb-2 mb-sm-0">
                  <h1>Manage Category Product</h1>
               </div>
               <div class="ml-auto d-flex align-items-center">
                  <a class="btn btn-secondary" href="{{ route('category') }}">Category</a>
               </div>
            </div>
            <!-- end page title -->
         </div>
      </div>
      <!-- end row -->
      <!-- begin row -->
      <div class="row editable-wrapper">
         <div class="col-lg-12 ">
            <div class="card card-statistics">
               <div class="card-body">
                  <div class="table-responsive">
                     <table id="table" class="table display responsive nowrap table-light table-bordered">
                        <thead class="thead-light">
                           <tr>
                              <th scope="col">id</th>
                              <!-- <th scope="col">Order By</th> -->
                              <th scope="col">Product Name</th>
                                 <th scope="col">Product Slug</th>
                         
                           </tr>
                        </thead>
                        <tbody>
                           @if(!$category_product->isEmpty())
                           @foreach($category_product as $key => $data)
                           <tr>
                               
                              <th scope="row">{{ ($key+1) }}</th>
                               <!-- <td>
                               <form class="update-order-form">
                                    @csrf
                                    <input type="hidden" name="category_id" value="{{ $data->category_id }}">
                                    <input type="hidden" name="product_id" value="{{ $data->product_id }}">
                                    <input type="text" name="order_by" class="order-by-input" value="{{ $data->order_by }}">
                                    
                                </form>
                                </td>
                                 -->
                              <td>{{ $data->product_name }}</td>
                            
                               <td>{{ $data->product_slug }}</td>
                           </tr>
                           @endforeach  
                           @else
                           <p class="text-danger mt-2" style="padding-left:450px;">No Category Product Available</p>
                           @endif
                        </tbody>
                     </table>
                  </div>
               </div>
            </div>
         </div>
      </div>
      <!-- end row -->
   </div>
   <!-- end container-fluid -->
</div>
<!-- end app-main -->
</div>
<!-- end app-container -->
<!-- Include jQuery library -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script>
    $(document).ready(function () {
        $('.update-order-form').on('submit', function (e) {
            e.preventDefault(); // Prevent the default form submission
            var form = $(this);
            var formData = form.serialize();
            $.ajax({
                url: '{{ route("update_order_route") }}', // Replace with your route URL
                type: 'POST',
                data: formData,
                success: function (response) {
                    // Handle success if needed
                    console.log(response);
                },
                error: function (xhr, status, error) {
                    // Handle error if needed
                    console.log(xhr.responseText);
                }
            });
        });
    });
</script>
@endsection