@extends('Admin.Layout.main_layout') 	
@section('title','Manage Product')
@section('main_container')
<!-- begin app-main -->
<div class="app-main" id="main">
   <!-- begin container-fluid -->
   <div class="container-fluid">
      <!-- begin row -->
      <div class="row">
         <div class="col-md-12 m-b-30">
            <!-- begin page title -->
            <div class="d-block d-sm-flex flex-nowrap align-items-center">
               <div class="page-title mb-2 mb-sm-0">
                  <h1>Manage CMS</h1>
               </div>
               <div class="ml-auto d-flex align-items-center">
                  <a class="btn btn-secondary" href="{{ route('addCMS') }}">Add CMS</a>
               </div>
            </div>
            <!-- end page title -->
         </div>
      </div>
      <!-- end row -->
      <!-- begin row -->
      <div class="row editable-wrapper">
         <div class="col-lg-12 ">
            <div class="card card-statistics">
               <div class="card-body">
                  <div class="table-responsive">
                     <table id="table" class="table display responsive nowrap table-light table-bordered">
                        <thead class="thead-light">
                           <tr>
                              <th scope="col">id</th>
                              <!-- <th scope="col">Banner Img</th> -->
                              <th scope="col">Page Title</th>
                              <th scope="col">Slug</th>
                              <th class="text-center">Actions</th>
                           </tr>
                        </thead>
                        <tbody>
                        @if(!$cms_arr->isEmpty())
                        @foreach($cms_arr as $key => $data)
                           <tr>
                              <th scope="row">{{ ($key+1) }}</th>
                              <!-- <td><img src="{{asset('public/upload/cms/' . $data->banner_img)}}" height="50px" width="50px"/></td> -->
                              <td>{{ $data->page_title }}</td>
                              <td>{{ $data->slug }}</td>
                              <td class="text-left">
                                 <div class="actions">
                                    <a class="btn btn-sm bg-success-light"  href="{{ route('editCMS', $data->id)}}">
                                    <i class="fe fe-edit" style="font-size: 2em;"></i> 
                                    </a>
                                    <a  href="javascript:void(0)" data-delete_url="{{url('cms/delete/'.$data->id)}}"   class="btnDelete btn btn-sm bg-danger-light">
                                    <i class="fe fe-trash" style="font-size: 2em;"></i> 
                                    </a>
                                 </div>
                              </td>
                           </tr>
                           @endforeach  
                           @else
                           <p class="text-danger mt-2" style="padding-left:450px;">No Page Available</p>
                           @endif
                        </tbody>
                     </table>
                  </div>
               </div>
            </div>
         </div>
      </div>
      <!-- end row -->
   </div>
   <!-- end container-fluid -->
</div>
<!-- end app-main -->
</div>
<!-- end app-container -->
@endsection