@extends('Admin.Layout.main_layout') 	
@section('main_container')
<!-- begin app-main -->
<div class="app-main" id="main">
   <!-- begin container-fluid -->
   <div class="container-fluid">
      <!-- begin row -->
      <div class="row">
         <div class="col-md-12 m-b-30">
            <!-- begin page title -->
            <div class="d-block d-sm-flex flex-nowrap align-items-center">
               <div class="page-title mb-2 mb-sm-0">
                  <h1>Video</h1>
               </div>
               <div class="ml-auto d-flex align-items-center">
                  <a class="btn btn-secondary" href="{{ route('video') }}">Manage Video</a>
               </div>
            </div>
            <!-- end page title -->
         </div>
      </div>
      <!-- end row -->
      <!--mail-Compose-contant-start-->
      <div class="row account-contant">
         <div class="col-12">
            <div class="card card-statistics">
               <div class="card-body p-0">
                
                     <div class="page-account-form">
                        <div class="form-titel border-bottom p-3">
                           <h5 class="mb-0 py-2">Add Video</h5>
                        </div>
                        <div class="p-3">
                           <form role="form" method="POST" enctype="multipart/form-data" action="{{ route('createVideo') }}">
                              @csrf
                              <div class="row">
                                 <div class="col-lg-6 col-md-6 col-sm-12 col-12">
                                    <div class="form-group">
                                       <label>Video Title</label>
                                       <input class="form-control"  name="video_title" value="{{ old('video_title') }}"  type="text">
                                    </div>
                                 </div>
                                  <div class="col-lg-6 col-md-6 col-sm-12 col-12">
                                    <div class="form-group">
                                       <label>Video Link<span style="color:#ff0000">*</span></label>
                                       <input class="form-control"  name="video_link"  value="{{ old('video_title') }}"  type="text">
                                        @error('video_link')
                                         <p class="text-danger"><small>{{ $message }}</small></p>
                                        @enderror
                                    </div>
                                 </div>
                              </div>
                              
                                <div class="row">
                                  <div class="col-lg-6 col-md-6 col-sm-12 col-12">
                                     <div class="form-group">
                                        <label>Video Image</label>
                                       <input class="form-control"   name="video_image" type="file">
                                        @error('video_image')
                                        <p class="text-danger"><small>{{ $message }}</small></p>
                                        @enderror
                                     </div>
                                  </div>
                              </div>


                              <div class="row">
                                 <div class="col-lg-12 col-md-12 col-sm-12 col-12">
                                    <div class="text-left">
                                       <button type="submit" id="submit" class="btn btn-secondary my-4">Add</button>
                                       <a href="{{ route('video') }}"  class="btn btn-danger my-4">Cancel</a>
                                    </div>
                                 </div>
                              </div>

                           </form>
                        </div>
                        
                     </div>
                 
               </div>
            </div>
         </div>
      </div>
      <!--mail-Compose-contant-end-->
   </div>
   <!-- end container-fluid -->
</div>
<!-- end app-main -->
</div>
<!-- end app-container -->
@endsection
