@extends('Admin.Layout.main_layout') 	
@section('main_container')
<!-- begin app-main -->
<div class="app-main" id="main">
   <!-- begin container-fluid -->
   <div class="container-fluid">
      <!-- begin row -->
      <div class="row">
         <div class="col-md-12 m-b-30">
            <!-- begin page title -->
            <div class="d-block d-sm-flex flex-nowrap align-items-center">
               <div class="page-title mb-2 mb-sm-0">
                  <h1>Manage Video</h1>
               </div>
               <div class="ml-auto d-flex align-items-center">
                  <a class="btn btn-secondary" href="{{ route('addVideo') }}">Add Video</a>
               </div>
            </div>
            <!-- end page title -->
         </div>
      </div>
      <!-- end row -->
      <!-- begin row -->
      <div class="row editable-wrapper">
         <div class="col-lg-12 ">
            <div class="card card-statistics">
               <div class="card-body">
                  <div class="table-responsive">
                     <table id="table" class="table display responsive nowrap table-light table-bordered">
                        <thead class="thead-light">
                           <tr>
                              <th scope="col">id</th>
                              <th scope="col">Video Title</th>
                              <th scope="col">Actions</th>
                           </tr>
                        </thead>
                        <tbody>
                           @if(!$video->isEmpty())
                           @foreach($video as $key => $data)
                           <tr>
                              <th scope="row">{{ ($key+1) }}</th>
                              <td>{{ $data->video_title }}</td>
                              <td>
                                 <div class="actions">
                                    <a class="btn btn-sm bg-success-light"  href="{{ route('editVideo', $data->video_id)}}">
                                    <i class="fe fe-edit" style="font-size: 2em;"></i> 
                                    </a>
                                    <a  href="javascript:void(0)" data-delete_url="{{url('video/delete/'.$data->video_id)}}"   class="btnDelete btn btn-sm bg-danger-light">
                                    <i class="fe fe-trash" style="font-size: 2em;"></i> 
                                    </a>
                                 </div>
                              </td>
                           </tr>
                           @endforeach  
                           @else
                           <p class="text-danger mt-2" style="padding-left:450px;">No Video Available</p>
                           @endif
                        </tbody>
                     </table>
                  </div>
               </div>
            </div>
         </div>
      </div>
      <!-- end row -->
   </div>
   <!-- end container-fluid -->
</div>
<!-- end app-main -->
</div>
<!-- end app-container -->
@endsection