<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Api\product_api_controller;
use App\Http\Controllers\Api\faq_api_controller;
use App\Http\Controllers\Api\product_detail_api_controller;
use App\Http\Controllers\Api\banner_home_api_controller;
use App\Http\Controllers\Api\cms_api_controller;
use App\Http\Controllers\Api\home_setting_api_controller;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

Route::middleware('auth:sanctum')->get('/user', function (Request $request) {
    return $request->user();
});
//Banner
Route::get('banner', 'App\Http\Controllers\Api\BannerController@index');




//category wise product listing
Route::get('product_category/{slug}','App\Http\Controllers\Api\ProductController@product_category'); 
Route::get('product_category_listing','App\Http\Controllers\Api\ProductController@allcategory'); 


//gallery
Route::get('gallary', 'App\Http\Controllers\Api\GallaryController@index');
Route::get('infrastructure', [\App\Http\Controllers\Api\InfrastructureController::class, 'allImages']);

//category
Route::get('category_listing', 'App\Http\Controllers\Api\CategoryController@index');


//product
Route::get('product','App\Http\Controllers\Api\ProductController@allshow'); 
Route::get('product_detail/{slug}','App\Http\Controllers\Api\ProductController@product_detail'); 
// Route::get('category_products_list', 'App\Http\Controllers\Api\ProductController@category_products_list');

//homepage
// Route::get('home_product_listing', 'App\Http\Controllers\Api\HomePageController@home_product_listing');
Route::get('home_product_listing', 'App\Http\Controllers\Api\ProductController@home_product_listing');
// Route::get('home_certificate_listing', 'App\Http\Controllers\Api\HomePageController@certificate_listing');
// Route::get('home_client_listing', 'App\Http\Controllers\Api\HomePageController@client_listing');
// Route::get('home_category_listing', 'App\Http\Controllers\Api\HomePageController@category_listing');
// Route::get('FilterProduct','App\Http\Controllers\Api\HomePageController@FilterProduct');
// Route::get('menu_category', 'App\Http\Controllers\Api\HomePageController@menu_category');
////blog
// Route::get('blog', 'App\Http\Controllers\Api\BlogController@blog_list');
// Route::get('blog_detail/{slug}', 'App\Http\Controllers\Api\BlogController@index');
// Route::get('blog_side_list', 'App\Http\Controllers\Api\BlogController@blog_side_list');
//client
// Route::get('client', 'App\Http\Controllers\Api\CertificateController@client');

//video
// Route::get('video', 'App\Http\Controllers\Api\CertificateController@video');

//certificate
// Route::get('certificate', 'App\Http\Controllers\Api\CertificateController@certificate');

//industry
Route::get('industry', 'App\Http\Controllers\Api\IndustryController@industry');
// Route::get('machine', 'App\Http\Controllers\Api\IndustryController@application');

////page
Route::get('page_list', 'App\Http\Controllers\Api\CmsController@page_list');
Route::get('page/{slug}', 'App\Http\Controllers\Api\CmsController@index');

//contact details
Route::get('contact_list', 'App\Http\Controllers\Api\ContactUsController@contact_list');

//Contact
Route::post('contact_store', 'App\Http\Controllers\Api\ContactUsController@contact_store');
Route::post('inquiry_store', 'App\Http\Controllers\Api\ContactUsController@inquiry_store');
Route::post('product_inquiry', 'App\Http\Controllers\Api\ContactUsController@product_inquiry');

Route::post('product_inquirey_store', 'App\Http\Controllers\Api\ContactUsController@product_inquirey_store');

